-- Pixelpost Updater 2.applescript
-- Pixelpost Updater 2

--  Created by Jay Williams on 12/25/06.
--  Copyright 2006 __MyCompanyName__. All rights reserved.
(* ==== Properties ==== *)

-- eg: {"PICT", "JPEG", "GIFf", "TIFF"} 
property type_list : {"JPEG"}
-- since file types are optional in Mac OS X, 
-- check the name extension if there is no file type 
-- NOTE: do not use periods (.) with the items in the name extensions list 
-- eg: {"txt", "text", "jpg", "jpeg"}, NOT: {".txt", ".text", ".jpg", ".jpeg"} 
property extension_list : {"jpg", "jpeg"}

property post_alert : true

property panelWIndow : missing value

property choosefile : false


-- Set Default Properties
property address : ""
property postkey : ""
property headline : ""
property categories : ""
property body : ""
property autodate : ""
property userfile : ""
property command : missing value

property showProgress : true
property progressPanel : missing value


on idle
	if choosefile is equal to true then
		
		set runonce to true
		set userfile to choose file with prompt "Select a image:" of type type_list
		
		if userfile is not equal to "" then
			-- quit
			
			set contents of text field "userfile" of window "main" to userfile
			set choosefile to false
			return
			
		end if
		
		
	end if
end idle

(* ==== Event Handlers ==== *)

on clicked theObject
	-- Settings Button Pressed
	if name of theObject is "settings" then
		set address to contents of text field "address" of window "main"
		set postkey to contents of text field "postkey" of window "main"
		
		-- Load the panel. We do this by loading the nib that contains the panel window, and then setting our property to the loaded window. Only do this once, as every time the nib is loaded, it will create new copies of all of the top level objects in the nib.
		if panelWIndow is equal to missing value then
			load nib "SettingsPanel"
			set panelWIndow to window "settings"
		end if
		
		-- Set the state of the items in the panel
		tell panelWIndow
			set contents of text field "address" to address
			set contents of text field "postkey" to postkey
		end tell
		
		-- Display the panel
		display panel panelWIndow attached to window "main"
		
		-- Upload Button Pressed
	else if name of theObject is "upload" then
		
		
		-- Get Variables
		set address to contents of text field "address" of window "main"
		set headline to contents of text field "headline" of window "main"
		set categories to contents of text field "categories" of window "main"
		set body to contents of text view "body" of scroll view "body" of window "main"
		set autodate to contents of text field "autodate" of window "main"
		set postkey to contents of text field "postkey" of window "main"
		set userfile to contents of text field "userfile" of window "main"
		
		-- Simple Error Checking
		if address is equal to "http://www.example.com/admin/uploader.php" then
			return
		else if headline is equal to "" then
			return
		else if postkey is equal to "ChangeMe" then
			return
		else if userfile is equal to "" then
			return
		end if
		
		set headline to (urlencode(headline))
		set categories to (urlencode(categories))
		set body to (urlencode(body))
		set autodate to (urlencode(autodate))
		set postkey to (urlencode(postkey))
		
		showProgressPanel(true, path name of save panel)
		
		try
			do shell script ("curl -F \"userfile=@" & userfile & "\" -F \"headline=" & headline & "\" " & " -F \"categories=" & categories & "\" " & " -F \"body=" & body & "\" " & " -F \"autodate=" & autodate & "\" " & " -F \"postkey=" & postkey & "\" " & address)
			--	curl -F "userfile=@/Users/d3designs/Desktop/IMG_0886_RAW_resized.jpg" -F "headline=Title" -F "category[]=1" -F "body=Cool text file with cool text inside" -F "autodate=2" -F "postkey=8BA0F3D685FCD96B456BF0405796AD53622EB44FED0FBE7AA504000780DD56FD" -F "submit=Upload" http://dev.d3done.com/test.php
			
		on error
			-- display dialog "Error!"
			hideProgressPanel(true)
			display alert "Error" as critical message "A problem occoured while uploading. Please check your settings and image file for errors." default button "OK" attached to window "main"
			
			return
		end try
		
		
		
		--	delay 5
		hideProgressPanel(true)
		--	display alert "Complete" as informational message "The image has been uploaded to Pixelpost." default button "Quit" attached to window "main"
		
		
		quit
		
		
	end if
end clicked

on panel ended thePanel with result theResult
	if theResult is 1 then
		local address
		local postkey
		
		tell thePanel
			set address to contents of text field "address"
			set postkey to contents of text field "postkey"
		end tell
		-- set address to contents of default entry "address" of user defaults
		--set postkey to contents of default entry "postkey" of user defaults
		
		set contents of default entry "address" of user defaults to address
		set contents of default entry "postkey" of user defaults to postkey
		
		set contents of text field "address" of window "main" to address
		set contents of text field "postkey" of window "main" to postkey
		--		call method "synchronize" of object user defaults
		
	end if
end panel ended

on open these_items
	set choosefile to false
	
	repeat with i from 1 to the count of these_items
		set this_item to item i of these_items
		set the item_info to info for this_item
		if (folder of the item_info is false) and (alias of the item_info is false) and ((the file type of the item_info is in the type_list) or the name extension of the item_info is in the extension_list) then
			process_item(this_item)
			
		else if post_alert is true then
			set AppleScript's text item delimiters to ", "
			set the display_list to type_list as string
			set AppleScript's text item delimiters to ""
			tell application (path to frontmost application as string)
				beep
				set choosefile to true
				--display dialog "This droplet only processes files of type:" & return & return & display_list giving up after 15
				--	tell window named "main"
				--		quit
				--	end tell
				
				-- displayName(choose file with prompt "Select a image:")
			end tell
		end if
	end repeat
end open

-- this sub-routine processes files 
on process_item(this_item)
	-- NOTE that the variable this_item is afile refernce in alias format 
	-- FILE PROCESSING STATEMENTS GOES HERE
	set contents of text field "userfile" of window "main" to this_item
end process_item

--on open names
(* Add your script to process the names here. *)

-- Remove the following line if you want the application to stay open.
-- quit
-- set userfile to names
--	set contents of text field "userfile" of window "main" to names
--end open

-- Populate window values
on opened theObject
	-- Save them into a preference file & generate one if it doesn't exist
	make new default entry at end of default entries of user defaults with properties {name:"address", contents:"http://www.example.com/admin/uploader.php"}
	make new default entry at end of default entries of user defaults with properties {name:"postkey", contents:"ChangeMe"}
	
	set address to contents of default entry "address" of user defaults
	set postkey to contents of default entry "postkey" of user defaults
	
	set contents of text field "address" of window "main" to address
	set contents of text field "postkey" of window "main" to postkey
	
	
	set choosefile to true
	
	
end opened

-- Loads the progress panel (if needed) and then displays it.
-- 
on showProgressPanel(attachedToWindow, archiveFileName)
	-- Only load the progress panel once.
	if progressPanel is missing value then
		load nib "ProgressPanel"
		set progressPanel to window "progress"
	end if
	
	-- Set the status item in the progress panel
	set content of text field "status" of progressPanel to "Uploading Photo"
	
	-- Display the progress panel appropriately.
	if attachedToWindow then
		display panel progressPanel attached to window "main"
	else
		show progressPanel
	end if
	
	-- Start spinning the progress bar.
	tell progressPanel
		set uses threaded animation of progress indicator "progress" to true
		tell progress indicator "progress" to start
	end tell
end showProgressPanel

-- Hides the progress panel.
-- 
on hideProgressPanel(attachedToWindow)
	if attachedToWindow then
		tell progress indicator "progress" of progressPanel to stop
		close panel progressPanel
	else
		hide progressPanel
	end if
	
	-- Set the status item in the progress panel
	set content of text field "status" of progressPanel to ""
end hideProgressPanel

-- this sub-routine is used to encode text
on urlencode(theText)
	set theTextEnc to ""
	repeat with eachChar in characters of theText
		set useChar to eachChar
		set eachCharNum to ASCII number of eachChar
		if eachCharNum = 32 then
			set useChar to "+"
		else if (eachCharNum  42) and (eachCharNum  95) and (eachCharNum < 45 or eachCharNum > 46) and (eachCharNum < 48 or eachCharNum > 57) and (eachCharNum < 65 or eachCharNum > 90) and (eachCharNum < 97 or eachCharNum > 122) then
			set firstDig to round (eachCharNum / 16) rounding down
			set secondDig to eachCharNum mod 16
			if firstDig > 9 then
				set aNum to firstDig + 55
				set firstDig to ASCII character aNum
			end if
			if secondDig > 9 then
				set aNum to secondDig + 55
				set secondDig to ASCII character aNum
			end if
			set numHex to ("%" & (firstDig as string) & (secondDig as string)) as string
			set useChar to numHex
		end if
		set theTextEnc to theTextEnc & useChar as string
	end repeat
	return theTextEnc
end urlencode
